/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.pkg;

import de.uzk.hki.da.pkg.ArchiveBuilder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarGZArchiveBuilder
implements ArchiveBuilder {
    static final Logger logger = LoggerFactory.getLogger(TarGZArchiveBuilder.class);

    TarGZArchiveBuilder() {
    }

    @Override
    public void unarchiveFolder(File srcTar, File destFolder) throws Exception {
        TarArchiveEntry entry;
        FileInputStream fin = new FileInputStream(srcTar);
        BufferedInputStream in = new BufferedInputStream(fin);
        GzipCompressorInputStream gzIn = new GzipCompressorInputStream(in);
        TarArchiveInputStream tIn = new TarArchiveInputStream(gzIn);
        HashMap<String, Long> modDateMap = new HashMap<String, Long>();
        while ((entry = tIn.getNextTarEntry()) != null) {
            logger.debug(entry.getName());
            String dstName = destFolder.getAbsolutePath() + "/" + entry.getName();
            File entryFile = new File(dstName);
            if (entry.isDirectory()) {
                entryFile.mkdirs();
                modDateMap.put(dstName, new Long(entry.getModTime().getTime()));
                continue;
            }
            new File(entryFile.getAbsolutePath().substring(0, entryFile.getAbsolutePath().lastIndexOf(47))).mkdirs();
            FileOutputStream out = new FileOutputStream(entryFile);
            IOUtils.copy((InputStream)tIn, (OutputStream)out);
            out.close();
            entryFile.setLastModified(entry.getModTime().getTime());
        }
        tIn.close();
        gzIn.close();
        in.close();
        fin.close();
        for (Map.Entry moddi : modDateMap.entrySet()) {
            String key = (String)moddi.getKey();
            Long value = (Long)moddi.getValue();
            new File(key).setLastModified(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void archiveFolder(File srcFolder, File destFile, boolean includeFolder) throws Exception {
        FileOutputStream fOut = null;
        BufferedOutputStream bOut = null;
        GzipCompressorOutputStream gzOut = null;
        TarArchiveOutputStream tOut = null;
        try {
            fOut = new FileOutputStream(destFile);
            bOut = new BufferedOutputStream(fOut);
            gzOut = new GzipCompressorOutputStream(bOut);
            tOut = new TarArchiveOutputStream(gzOut);
            tOut.setLongFileMode(2);
            tOut.setBigNumberMode(2);
            if (includeFolder) {
                this.addFileToTarGZ(tOut, srcFolder, "");
            } else {
                File[] children = srcFolder.listFiles();
                for (int i = 0; i < children.length; ++i) {
                    this.addFileToTarGZ(tOut, children[i], "");
                }
            }
        }
        finally {
            tOut.finish();
            tOut.close();
            gzOut.close();
            bOut.close();
            fOut.close();
        }
    }

    private void addFileToTarGZ(TarArchiveOutputStream tOut, File file, String base) throws IOException {
        String entryName = base + file.getName();
        logger.debug("addFileToTarGZ: " + entryName);
        TarArchiveEntry entry = (TarArchiveEntry)tOut.createArchiveEntry(file, entryName);
        tOut.putArchiveEntry(entry);
        if (file.isFile()) {
            FileInputStream fis = new FileInputStream(file);
            IOUtils.copy((InputStream)fis, (OutputStream)tOut);
            tOut.closeArchiveEntry();
            fis.close();
        }
        if (file.isDirectory()) {
            tOut.closeArchiveEntry();
            File[] children = file.listFiles();
            if (children == null) {
                return;
            }
            for (int i = 0; i < children.length; ++i) {
                this.addFileToTarGZ(tOut, children[i], entryName + "/");
            }
        }
    }
}

