/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.sb;

import de.uzk.hki.da.sb.SIPFactory;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;

public class UserInputValidator {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private static final char[] illegalFilenameCharacters = new char[]{'/', '\\', '\n', '\r', '\t', '\u0000', '\f', '`', '\"', '?', '*', '<', '>', '|', ':'};

    public static Feedback checkPaths(String sourcePath, String destinationPath, SIPFactory.KindOfSIPBuilding kindOfSipBuilding) {
        if (sourcePath == null || sourcePath.equals("")) {
            return Feedback.NO_SOURCE_PATH;
        }
        if (!new File(sourcePath).isDirectory()) {
            return Feedback.SOURCE_PATH_DOES_NOT_EXIST;
        }
        if (destinationPath == null || destinationPath.equals("")) {
            return Feedback.NO_DESTINATION_PATH;
        }
        if (sourcePath.equals(destinationPath)) {
            return Feedback.FOLDER_EQUALITY;
        }
        if (destinationPath.startsWith(sourcePath)) {
            return Feedback.SUBFOLDER;
        }
        if (kindOfSipBuilding == SIPFactory.KindOfSIPBuilding.MULTIPLE_FOLDERS) {
            List<File> subFolders = Arrays.asList(new File(sourcePath).listFiles());
            for (File folder : subFolders) {
                if (folder.isDirectory() || folder.isHidden()) continue;
                return Feedback.NON_DIRECTORY_FILES_EXIST;
            }
        }
        return Feedback.VALID;
    }

    public static Feedback checkCollectionName(String collectionName, String destinationPath) {
        if (collectionName == null || collectionName.equals("")) {
            return Feedback.NO_COLLECTION_NAME;
        }
        for (char character : illegalFilenameCharacters) {
            if (collectionName.indexOf(character) == -1) continue;
            return Feedback.INVALID_COLLECTION_NAME;
        }
        if (new File(destinationPath + File.separator + collectionName).exists()) {
            return Feedback.COLLECTION_ALREADY_EXISTS;
        }
        return Feedback.VALID;
    }

    public static Feedback checkSipName(String sipName) {
        for (char character : illegalFilenameCharacters) {
            if (sipName.indexOf(character) == -1) continue;
            return Feedback.INVALID_SIP_NAME;
        }
        return Feedback.VALID;
    }

    public static Feedback checkDate(String date) {
        if (date == null || date.equals("")) {
            return Feedback.NO_DATE;
        }
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(date);
        }
        catch (Exception exc) {
            return Feedback.INVALID_DATE;
        }
        return Feedback.VALID;
    }

    public static enum Feedback {
        VALID,
        NO_SOURCE_PATH,
        NO_DESTINATION_PATH,
        SOURCE_PATH_DOES_NOT_EXIST,
        FOLDER_EQUALITY,
        SUBFOLDER,
        NON_DIRECTORY_FILES_EXIST,
        NO_COLLECTION_NAME,
        INVALID_COLLECTION_NAME,
        COLLECTION_ALREADY_EXISTS,
        INVALID_SIP_NAME,
        NO_DATE,
        INVALID_DATE;

    }
}

