/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.utils;

import de.uzk.hki.da.pkg.SipArchiveBuilder;
import de.uzk.hki.da.sb.Feedback;
import de.uzk.hki.da.sb.ProgressManager;
import de.uzk.hki.da.sb.SIPFactory;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ExistingSIPModifier {
    private static Logger logger = LogManager.getLogger(ExistingSIPModifier.class);
    SIPFactory sipFactory = new SIPFactory();
    SipArchiveBuilder sipArchiveBuilder;

    protected abstract Feedback doModificationOnSIPData(File var1) throws IOException;

    public ExistingSIPModifier() {
        this.sipFactory.setProgressManager(new SimpleLoggerProgressManager());
        this.sipFactory.setSipBuildingProcess(new SIPFactory.SipBuildingProcess(this.sipFactory){

            @Override
            public void run() {
            }
        });
        this.sipArchiveBuilder = new SipArchiveBuilder();
        this.sipArchiveBuilder.setProgressManager(new SimpleLoggerProgressManager());
        this.sipArchiveBuilder.setJobId(0);
        this.sipArchiveBuilder.setSipBuildingProcess(new SIPFactory.SipBuildingProcess(this.sipFactory){

            @Override
            public void run() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feedback startModifyExistingSip(String sourceSip, String destinationPath) throws IOException {
        File unpackedWorkingDir;
        Feedback returnValue = Feedback.SUCCESS;
        File sourceSipFile = new File(sourceSip);
        File unpackedSIPDir = unpackedWorkingDir = new File(destinationPath, "workDirFor-" + this.getClass().getSimpleName());
        boolean compressed = false;
        boolean sourceSipIsDir = new File(sourceSip).isDirectory();
        if (unpackedWorkingDir.exists()) {
            try {
                FileUtils.deleteDirectory(unpackedWorkingDir);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        unpackedWorkingDir.mkdirs();
        try {
            if (!sourceSipIsDir) {
                String extention = sourceSipFile.getName().substring(sourceSipFile.getName().lastIndexOf(46) + 1);
                if (extention.equalsIgnoreCase("tar")) {
                    try {
                        this.sipArchiveBuilder.unarchiveFolder(sourceSipFile, unpackedWorkingDir, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        returnValue = Feedback.ARCHIVE_ERROR;
                    }
                } else if (extention.equalsIgnoreCase("tgz")) {
                    compressed = true;
                    this.sipFactory.setCompress(compressed);
                    try {
                        this.sipArchiveBuilder.unarchiveFolder(sourceSipFile, unpackedWorkingDir, true);
                        if (unpackedWorkingDir.listFiles().length != 1 || !unpackedWorkingDir.listFiles()[0].isDirectory()) {
                            logger.error(String.format("Untaring %s to dir %s. is not as expected", sourceSipFile.getAbsolutePath(), unpackedWorkingDir.getAbsolutePath()));
                            returnValue = Feedback.ARCHIVE_ERROR;
                        }
                        unpackedSIPDir = unpackedWorkingDir.listFiles()[0];
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        returnValue = Feedback.ARCHIVE_ERROR;
                    }
                }
            } else {
                unpackedSIPDir = new File(unpackedWorkingDir, sourceSipFile.getName());
                try {
                    FileUtils.copyDirectory(sourceSipFile, unpackedSIPDir);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    returnValue = Feedback.COPY_ERROR;
                }
            }
            try {
                ExistingSIPModifier.restructureUnpackedSIP(unpackedSIPDir);
            }
            catch (IOException e) {
                e.printStackTrace();
                returnValue = Feedback.COPY_ERROR;
            }
            this.doModificationOnSIPData(unpackedSIPDir);
            if (returnValue == Feedback.SUCCESS) {
                returnValue = this.sipFactory.createBag(0, unpackedSIPDir);
            }
            if (returnValue == Feedback.SUCCESS) {
                if (sourceSipIsDir) {
                    FileUtils.moveDirectory(sourceSipFile, new File(destinationPath, sourceSipFile.getName()));
                } else {
                    this.sipFactory.buildArchive(0, unpackedSIPDir, new File(destinationPath, sourceSipFile.getName()));
                }
            }
        }
        finally {
            FileUtils.deleteDirectory(unpackedWorkingDir);
        }
        return returnValue;
    }

    private static void restructureUnpackedSIP(File unpackedSIPDir) throws IOException {
        File dataDir = new File(unpackedSIPDir, "data");
        for (File tmp : unpackedSIPDir.listFiles()) {
            if (tmp.equals(dataDir)) continue;
            tmp.delete();
        }
        FileUtils.copyDirectory(dataDir, unpackedSIPDir);
        FileUtils.deleteDirectory(dataDir);
    }

    public static class SimpleLoggerProgressManager
    extends ProgressManager {
        @Override
        public void addJob(int id, String packageName, long folderSize) {
            logger.info("addJob(" + id + "," + packageName + "," + folderSize + ")");
        }

        @Override
        public void reset() {
            logger.info("reset()");
        }

        @Override
        public void calculateProgressParts(boolean createCollection) {
            logger.info("calculateProgressParts(" + createCollection + ")");
        }

        @Override
        public void copyProgress(int id, long processedData) {
            logger.info("copyProgress(" + id + "," + processedData + ")");
        }

        @Override
        public void premisProgress(int id, double progress) {
            logger.info("premisProgress(" + id + "," + progress + ")");
        }

        @Override
        public void bagitProgress(int id, double progress) {
            logger.info("bagitProgress(" + id + "," + progress + ")");
        }

        @Override
        public void archiveProgress(int id, long archivedData) {
            logger.info("archiveProgress(" + id + "," + archivedData + ")");
        }

        @Override
        public void deleteTempProgress(int id, double progress) {
            logger.info("deleteTempProgress(" + id + "," + progress + ")");
        }

        @Override
        public void skipJob(int id) {
            logger.info("skipJob(" + id + ")");
        }

        @Override
        public void createSuccessMessage(boolean skippedFiles) {
            logger.info("createSuccessMessage(" + skippedFiles + ")");
        }

        @Override
        public void setJobFolderSize(int id, long folderSize) {
            logger.info("setJobFolderSize(" + id + "," + folderSize + ")");
        }

        @Override
        public void abort() {
            logger.info("abort()");
        }

        @Override
        public void createStartMessage() {
            logger.info("createStartMessage()");
        }

        @Override
        public void startJob(int id) {
            logger.info("startJob(" + id + ")");
        }
    }
}

