/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public class MD5Checksum {
    static InputStream fis;

    public MD5Checksum(File file) throws FileNotFoundException {
        fis = new FileInputStream(file);
    }

    public MD5Checksum(String filename) throws FileNotFoundException {
        fis = new FileInputStream(filename);
    }

    private static byte[] createChecksum() {
        try {
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance("MD5");
            do {
                if ((numRead = fis.read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            fis.close();
            return complete.digest();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMD5Checksum() throws Exception {
        byte[] b = MD5Checksum.createChecksum();
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static String getMD5checksumForLocalFile(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("file " + file + " does not exist");
        }
        String md5sumHex = "";
        try (FileInputStream fis = new FileInputStream(file);){
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = fis.read(dataBytes)) != -1) {
                digest.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = digest.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            md5sumHex = sb.toString();
        }
        return md5sumHex;
    }
}

