/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.utils;

import de.uzk.hki.da.utils.CommandLineConnector;
import de.uzk.hki.da.utils.IOTimeoutException;
import de.uzk.hki.da.utils.ProcessInformation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplifiedCommandLineConnector {
    private static Logger logger = LoggerFactory.getLogger(SimplifiedCommandLineConnector.class);
    private CommandLineConnector cl;
    private String errorMessages;

    public SimplifiedCommandLineConnector() {
        this.cl = new CommandLineConnector();
    }

    public SimplifiedCommandLineConnector(CommandLineConnector cl) {
        this.cl = cl;
    }

    public boolean execute(String[] cmd) {
        return this.execute(cmd, 0L);
    }

    public boolean execute(String[] cmd, long timeout) {
        logger.trace("SimplifiedCommandLineConnector executing conversion command: {}", (Object)cmd.toString());
        this.errorMessages = null;
        ProcessInformation pi = null;
        File redirect = null;
        try {
            redirect = File.createTempFile("DANRWCMD", "log");
            pi = this.cl.runCmdSynchronously(cmd, null, timeout, redirect);
        }
        catch (IOTimeoutException e) {
            redirect.delete();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            redirect.delete();
            throw new RuntimeException(e);
        }
        if (pi.getExitValue() != 0) {
            try {
                BufferedReader bR = new BufferedReader(new FileReader(redirect));
                try {
                    this.errorMessages = new String();
                    String ls = System.lineSeparator();
                    String line = bR.readLine();
                    for (int lR = 0; line != null && lR < 50; ++lR) {
                        this.errorMessages = this.errorMessages + line + ls;
                        line = bR.readLine();
                    }
                    bR.close();
                }
                catch (IOException e) {
                    this.errorMessages = "Unable to read output";
                }
                try {
                    bR.close();
                }
                catch (IOException exctasy) {
                    logger.error("Unable to close output", exctasy);
                }
            }
            catch (FileNotFoundException exctasy) {
                this.errorMessages = "Unable to open output";
                logger.error("Unable to open output", exctasy);
            }
            redirect.delete();
            logger.error(this.getClass() + ": Recieved return code from terminal based command: " + pi.getExitValue());
            logger.error(this.errorMessages);
            return false;
        }
        redirect.delete();
        return true;
    }

    public String getErrorMessages() {
        return this.errorMessages;
    }
}

