/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtilities {
    public static Logger logger = LoggerFactory.getLogger(StringUtilities.class);
    public static final String EMPTY = "";

    public static String slashize(String arg) {
        if (arg != null && !arg.isEmpty() && !arg.endsWith("/")) {
            arg = arg + "/";
        }
        return arg;
    }

    public static void replace(String[] operateOn, String from, String to) {
        for (int i = 0; i < operateOn.length; ++i) {
            Pattern patternOutput = Pattern.compile(from);
            Matcher matcherOutput = patternOutput.matcher(operateOn[i]);
            operateOn[i] = matcherOutput.replaceFirst(to);
        }
    }

    public static String todayAsSimpleIsoDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        return formatter.format((Object)date);
    }

    public static boolean checkForWhitespace(String string) {
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public static String readFile(File file) {
        FileReader reader;
        try {
            reader = new FileReader(file.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Couldn't create reader", e);
        }
        String modsText = EMPTY;
        try {
            int c;
            while ((c = ((Reader)reader).read()) != -1) {
                modsText = modsText + (char)c;
            }
            ((Reader)reader).close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read file " + file.getAbsolutePath(), e);
        }
        return modsText;
    }

    public static String createString(String[] stringArray) {
        StringBuilder result = new StringBuilder(EMPTY);
        for (String s : stringArray) {
            if (!result.equals(EMPTY)) {
                result.append(" ");
            }
            result.append(s);
        }
        return result.toString();
    }

    public static String createString(List<String> stringList) {
        StringBuilder result = new StringBuilder(EMPTY);
        for (String s : stringList) {
            if (!result.equals(EMPTY)) {
                result.append(" ");
            }
            result.append(s);
        }
        return result.toString();
    }

    public static boolean isNotSet(Object s) {
        if (s == null) {
            return true;
        }
        return s instanceof String && ((String)s).isEmpty();
    }

    public static boolean isSet(Object s) {
        return !StringUtilities.isNotSet(s);
    }
}

