/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.utils;

import de.uzk.hki.da.metadata.ContractRights;
import de.uzk.hki.da.metadata.EadParser;
import de.uzk.hki.da.metadata.LidoParser;
import de.uzk.hki.da.metadata.MetsParser;
import de.uzk.hki.da.metadata.PublicationRights;
import de.uzk.hki.da.sb.MessageWriter;
import de.uzk.hki.da.sb.SIPFactory;
import de.uzk.hki.da.utils.XMLUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utilities {
    private static Logger logger = LogManager.getLogger(Utilities.class);

    public static SIPFactory.KindOfSIPBuilding translateKindOfSIPBuilding(String kindofSIPBuildingName) {
        if (kindofSIPBuildingName.equals("SIPs aus Unterordnern des Quellverzeichnisses erstellen")) {
            return SIPFactory.KindOfSIPBuilding.MULTIPLE_FOLDERS;
        }
        if (kindofSIPBuildingName.equals("Ein SIP aus dem Quellverzeichnis erstellen")) {
            return SIPFactory.KindOfSIPBuilding.SINGLE_FOLDER;
        }
        if (kindofSIPBuildingName.equals("SIPs aus verzweigter Ordnerstruktur erstellen (nur METS)")) {
            return SIPFactory.KindOfSIPBuilding.NESTED_FOLDERS;
        }
        return null;
    }

    public static ContractRights.ConversionCondition translateConversionCondition(String conversionConditionName) {
        if (conversionConditionName.equals("Keine")) {
            return ContractRights.ConversionCondition.NONE;
        }
        if (conversionConditionName.equals("\u00dcber Migration informieren")) {
            return ContractRights.ConversionCondition.NOTIFY;
        }
        if (conversionConditionName.equals("Zustimmung f\u00fcr Migration einholen")) {
            return ContractRights.ConversionCondition.CONFIRM;
        }
        return null;
    }

    public static String translateConversionCondition(ContractRights.ConversionCondition conversionConditionEnum) {
        if (conversionConditionEnum == ContractRights.ConversionCondition.NONE) {
            return "Keine";
        }
        if (conversionConditionEnum == ContractRights.ConversionCondition.NOTIFY) {
            return "\u00dcber Migration informieren";
        }
        if (conversionConditionEnum == ContractRights.ConversionCondition.CONFIRM) {
            return "Zustimmung f\u00fcr Migration einholen";
        }
        return null;
    }

    public static PublicationRights.TextType translateTextType(String textType) {
        if (textType.equals("Fu\u00dfzeile")) {
            return PublicationRights.TextType.footer;
        }
        if (textType.equals("Wasserzeichen (oben)")) {
            return PublicationRights.TextType.north;
        }
        if (textType.equals("Wasserzeichen (mittig)")) {
            return PublicationRights.TextType.center;
        }
        if (textType.equals("Wasserzeichen (unten)")) {
            return PublicationRights.TextType.south;
        }
        return null;
    }

    public static String translateTextType(PublicationRights.TextType textType) {
        if (textType == PublicationRights.TextType.footer) {
            return "Fu\u00dfzeile";
        }
        if (textType == PublicationRights.TextType.north) {
            return "Wasserzeichen (oben)";
        }
        if (textType == PublicationRights.TextType.center) {
            return "Wasserzeichen (mittig)";
        }
        if (textType == PublicationRights.TextType.south) {
            return "Wasserzeichen (unten)";
        }
        return null;
    }

    public static String translateTextTypePosition(PublicationRights.TextType textType) {
        if (textType == PublicationRights.TextType.footer) {
            return "Fu\u00dfzeile";
        }
        if (textType == PublicationRights.TextType.north) {
            return "oben";
        }
        if (textType == PublicationRights.TextType.center) {
            return "mittig";
        }
        if (textType == PublicationRights.TextType.south) {
            return "unten";
        }
        return null;
    }

    public static PublicationRights.Law translateLaw(String lawName) {
        if (lawName.equals("ePflicht")) {
            return PublicationRights.Law.EPFLICHT;
        }
        if (lawName.equals("UrhG DE")) {
            return PublicationRights.Law.URHG_DE;
        }
        return null;
    }

    public static String translateLaw(PublicationRights.Law lawEnum) {
        if (lawEnum == PublicationRights.Law.EPFLICHT) {
            return "ePflicht";
        }
        if (lawEnum == PublicationRights.Law.URHG_DE) {
            return "UrhG DE";
        }
        return null;
    }

    public static boolean checkForZeroByteFiles(File folder, String sipName, MessageWriter messageWriter) {
        Collection<File> files = FileUtils.listFiles(folder, null, true);
        for (File file : files) {
            if (file.length() != 0L) continue;
            String zeroByteFileEntry = file.getName() + " (" + sipName + ")";
            messageWriter.addZeroByteFile(zeroByteFileEntry);
        }
        return messageWriter.getZeroByteFiles().size() > 0;
    }

    public static String readFile(File file) throws Exception {
        FileReader reader;
        try {
            reader = new FileReader(file.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            throw new Exception("Couldn't create reader", e);
        }
        String text = "";
        try {
            int c;
            while ((c = ((Reader)reader).read()) != -1) {
                text = text + (char)c;
            }
            ((Reader)reader).close();
        }
        catch (IOException e) {
            throw new Exception("Couldn't read file " + file.getAbsolutePath(), e);
        }
        return text;
    }

    public static void writeFile(File outputFile, String text) throws Exception {
        FileWriter writer;
        try {
            writer = new FileWriter(outputFile);
        }
        catch (IOException e) {
            throw new Exception("Couldn't create writer", e);
        }
        try {
            writer.write(text);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new Exception("Couldn't write to file " + outputFile.getAbsolutePath(), e);
        }
    }

    public static void validateFileReferencesInMetadata(File metadataFile, String metadataType) throws Exception {
        logger.info("Checking references in metadata file " + metadataFile);
        List<Object> references = new ArrayList();
        ArrayList<String> wrongRefs = new ArrayList<String>();
        if (metadataType.equals("METS")) {
            references = new MetsParser(XMLUtils.getDocumentFromXMLFile(metadataFile)).getReferences();
        } else if (metadataType.equals("LIDO")) {
            references = new LidoParser(XMLUtils.getDocumentFromXMLFile(metadataFile)).getReferences();
        } else if (metadataType.equals("EAD")) {
            references = new EadParser(XMLUtils.getDocumentFromXMLFile(metadataFile)).getReferences();
        }
        for (String string : references) {
            if (Utilities.fileReferenceInXmlIsValid(string, metadataFile)) continue;
            wrongRefs.add(string);
        }
        if (!wrongRefs.isEmpty()) {
            String msg = "Die Metadatendatei " + metadataFile + " enth\u00e4lt falsche Referenzen.\nFolgende Dateien konnten nicht gefunden werden: \n" + wrongRefs;
            throw new Error(msg);
        }
    }

    private static boolean fileReferenceInXmlIsValid(String reference, File metadataFile) throws IOException {
        boolean isValid = false;
        File referencedFile = new File(metadataFile.getParentFile(), reference);
        logger.debug("Check reference " + reference + " in metadata file " + metadataFile);
        if (referencedFile.exists()) {
            logger.debug("File " + referencedFile.getAbsolutePath() + " exists.");
            File sipMain = new File(metadataFile.getParentFile(), "");
            logger.debug("Check if file is inside a sip canidate " + sipMain);
            if (referencedFile.getCanonicalPath().startsWith(sipMain.getCanonicalPath())) {
                logger.debug("File " + referencedFile + " is inside a sip");
                isValid = true;
            }
        }
        return isValid;
    }

    public static String getBuildNumber() {
        String buildNumber = "fakeBuildNumber";
        try {
            JarFile file = null;
            Manifest mf = null;
            file = new JarFile(new File(Utilities.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()));
            mf = file.getManifest();
            Attributes attr = mf.getMainAttributes();
            buildNumber = attr.getValue("buildNumber");
        }
        catch (Exception e) {
            logger.debug("Can not extract the build number from ");
        }
        return buildNumber;
    }
}

