/*
 * Decompiled with CFR 0.152.
 */
package de.uzk.hki.da.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.input.BOMInputStream;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    private static ErrorHandler myHandler = new XMLErrorHandler(System.err);

    public static SAXBuilder createValidatingSaxBuilder() {
        SAXBuilder builder = new SAXBuilder(true);
        builder.setValidation(true);
        builder.setErrorHandler(myHandler);
        builder.setFeature("http://xml.org/sax/features/validation", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return builder;
    }

    public static SAXParser createValidatingSaxParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        factory.setFeature("http://xml.org/sax/features/validation", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        SAXParser saxParser = factory.newSAXParser();
        return saxParser;
    }

    public static Document getDocumentFromXMLFile(File file) throws IOException, JDOMException {
        SAXBuilder builder = XMLUtils.createValidatingSaxBuilder();
        FileInputStream fileInputStream = new FileInputStream(file);
        BOMInputStream bomInputStream = new BOMInputStream(fileInputStream);
        InputStreamReader reader = new InputStreamReader((InputStream)bomInputStream, "UTF-8");
        InputSource is = new InputSource(reader);
        is.setEncoding("UTF-8");
        Document metsDoc = builder.build(is);
        fileInputStream.close();
        bomInputStream.close();
        ((Reader)reader).close();
        return metsDoc;
    }

    public static File getRelativeFileFromReference(String ref, File metadataFile) throws IOException {
        String parentFilePath = "";
        if (metadataFile.getParentFile() != null) {
            parentFilePath = metadataFile.getParentFile().getPath();
        }
        File file = new File(new File(parentFilePath, ref).getCanonicalFile().toString().replace(new File("").getCanonicalFile().toString(), ""));
        return file;
    }

    private static class XMLErrorHandler
    implements ErrorHandler {
        private PrintStream out;

        XMLErrorHandler(PrintStream out) {
            this.out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
            String message = "Warning: " + this.getParseExceptionInfo(spe);
            this.out.println(message);
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            this.out.println(message);
            throw new SAXException(message);
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            this.out.println(message);
            throw new SAXException(message);
        }
    }
}

