/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.reader;

import gov.loc.repository.bagit.domain.FetchItem;
import gov.loc.repository.bagit.exceptions.InvalidBagitFileFormatException;
import gov.loc.repository.bagit.exceptions.MaliciousPathException;
import gov.loc.repository.bagit.reader.TagFileReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FetchReader {
    private static final Logger logger = LoggerFactory.getLogger(FetchReader.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");
    private static final String FETCH_LINE_REGEX = ".*[ \t]*(\\d*|-)[ \t]*.*";

    private FetchReader() {
    }

    public static List<FetchItem> readFetch(Path fetchFile, Charset encoding, Path bagRootDir) throws IOException, MaliciousPathException, InvalidBagitFileFormatException {
        logger.info(messages.getString("reading_fetch_file"), (Object)fetchFile);
        ArrayList<FetchItem> itemsToFetch = new ArrayList<FetchItem>();
        try (BufferedReader reader = Files.newBufferedReader(fetchFile, encoding);){
            String line = reader.readLine();
            String[] parts = null;
            long length = 0L;
            URL url = null;
            while (line != null) {
                if (!line.matches(FETCH_LINE_REGEX) || line.matches("\\s*")) {
                    throw new InvalidBagitFileFormatException(messages.getString("invalid_fetch_file_line_error").replace("{}", line));
                }
                parts = line.split("\\s+", 3);
                Path path = TagFileReader.createFileFromManifest(bagRootDir, parts[2]);
                length = parts[1].equals("-") ? -1L : Long.decode(parts[1]);
                url = new URL(parts[0]);
                logger.debug(messages.getString("read_fetch_file_line"), url, length, parts[2], fetchFile);
                FetchItem itemToFetch = new FetchItem(url, length, path);
                itemsToFetch.add(itemToFetch);
                line = reader.readLine();
            }
        }
        return itemsToFetch;
    }
}

