/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify;

import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.exceptions.InvalidPayloadOxumException;
import gov.loc.repository.bagit.exceptions.PayloadOxumDoesNotExistException;
import gov.loc.repository.bagit.util.PathUtils;
import gov.loc.repository.bagit.verify.FileCountAndTotalSizeVistor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public final class QuickVerifier {
    private static final Logger logger = LoggerFactory.getLogger(QuickVerifier.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");
    private static final String PAYLOAD_OXUM_REGEX = "\\d+\\.\\d+";

    private QuickVerifier() {
    }

    public static boolean canQuickVerify(Bag bag) {
        String payloadOxum = QuickVerifier.getPayloadOxum(bag);
        logger.debug(messages.getString("found_payload_oxum"), (Object)payloadOxum, (Object)bag.getRootDir());
        return payloadOxum != null && payloadOxum.matches(PAYLOAD_OXUM_REGEX) && bag.getItemsToFetch().size() == 0;
    }

    private static String getPayloadOxum(Bag bag) {
        for (AbstractMap.SimpleImmutableEntry<String, String> keyValue : bag.getMetadata().getAll()) {
            if (!"Payload-Oxum".equals(keyValue.getKey())) continue;
            return keyValue.getValue();
        }
        return null;
    }

    public static void quicklyVerify(Bag bag) throws IOException, InvalidPayloadOxumException {
        String payloadOxum = QuickVerifier.getPayloadOxum(bag);
        if (payloadOxum == null || !payloadOxum.matches(PAYLOAD_OXUM_REGEX)) {
            throw new PayloadOxumDoesNotExistException(messages.getString("payload_oxum_missing_error"));
        }
        String[] parts = payloadOxum.split("\\.");
        logger.debug(messages.getString("parse_size_in_bytes"), (Object)parts[0]);
        long totalSize = Long.parseLong(parts[0]);
        logger.debug(messages.getString("parse_number_of_files"), (Object)parts[1]);
        long numberOfFiles = Long.parseLong(parts[1]);
        Path payloadDir = PathUtils.getDataDir(bag);
        FileCountAndTotalSizeVistor vistor = new FileCountAndTotalSizeVistor();
        Files.walkFileTree(payloadDir, vistor);
        logger.debug(messages.getString("compare_payload_oxums"), payloadOxum, vistor.getTotalSize(), vistor.getCount(), payloadDir);
        if (totalSize != vistor.getTotalSize()) {
            String formattedMessage = messages.getString("invalid_total_size_error");
            throw new InvalidPayloadOxumException(MessageFormatter.format(formattedMessage, totalSize, vistor.getTotalSize()).getMessage());
        }
        if (numberOfFiles != vistor.getCount()) {
            String formattedMessage = messages.getString("invalid_file_cound_error");
            throw new InvalidPayloadOxumException(MessageFormatter.format(formattedMessage, numberOfFiles, vistor.getCount()).getMessage());
        }
    }
}

